/**
 * WordPress dependencies
 */
import { __, sprintf } from '@wordpress/i18n';
import { Fragment } from '@wordpress/element';

/**
 * Internal dependencies
 */
import WrappedSection from './wrapped-section';
import Detail from './detail';

function MalwareDetails( { results } ) {
	if ( ! results.entries.malware.length ) {
		return <WrappedSection type="malware" status="clean" description={ __( 'Malware', 'it-l10n-ithemes-security-pro' ) } />;
	}

	return (
		<WrappedSection type="malware" status="warn" description={ __( 'Malware', 'it-l10n-ithemes-security-pro' ) }>
			{ results.entries.malware.map( ( entry, i ) => {
				let location = entry.location;
				const message = entry.message,
					documentation = entry.documentation,
					payload = entry.payload,
					type = entry.type;

				if ( ! location.match( /https?:\/\// ) ) {
					location = false;
				}

				return (
					<Detail key={ i } status="warn">
						{ message }
						{ location && (
							<Fragment>
								<br />
								{ __( 'Infected URL:', 'it-l10n-ithemes-security-pro' ) }
								{ location && <a href={ location } target="_blank" rel="noopener noreferrer">{ location }</a> }
							</Fragment>
						) }
						{ type.slug !== 'other' && (
							<Fragment>
								<br />
								{ sprintf( __( 'Type: %s', 'it-l10n-ithemes-security-pro' ), type.label ) }
								<br />
								{ __( 'Documentation:', 'it-l10n-ithemes-security-pro' ) }
								<a href={ documentation } target="_blank" rel="noopener noreferrer">{ documentation }</a>
							</Fragment>
						) }
						{ payload && (
							<Fragment>
								<br />
								{ __( 'Payload:', 'it-l10n-ithemes-security-pro' ) }
								<pre>{ payload }</pre>
							</Fragment>
						) }
					</Detail>
				);
			} ) }
		</WrappedSection>
	);
}

export default MalwareDetails;
