/**
 * WordPress dependencies
 */
import { __, sprintf } from '@wordpress/i18n';
import { RawHTML } from '@wordpress/element';
import { Modal } from '@wordpress/components';
import { compose, withState } from '@wordpress/compose';

/**
 * Internal dependencies
 */
import Header, { Title } from '../../components/card/header';
import { FooterSchemaActions } from '../../components/card/footer';
import { MalwareScanResults, SiteScanResults } from '@ithemes/security-components';

function ScanOnly( { card, config, scanResults, setState } ) {
	return (
		<div className="itsec-card--type-malware-scan itsec-card--type-malware--scan-only">
			<Header>
				<Title card={ card } config={ config } />
			</Header>
			<section className="itsec-card-malware-scan__description">
				<p>
					<RawHTML>
						{ sprintf(
							__( 'This malware scan is powered by %1$sSucuri SiteCheck%2$s. It checks for known malware, blacklisting status, website errors and out-of-date software. Although the Sucuri team does its best to provide thorough results, 100%% accuracy is not realistic and is not guaranteed.', 'it-l10n-ithemes-security-pro' ),
							'<a href="https://ithemes.com/sitecheck">',
							'</a>'
						) }
					</RawHTML>
				</p>
				<p>
					{ __( 'Enable Database Logging to see a history of completed Malware Scans.', 'it-l10n-ithemes-security-pro' ) }
				</p>
			</section>
			<FooterSchemaActions card={ card } onComplete={ ( href, response ) => href.endsWith( '/scan' ) && setState( { scanResults: response.results } ) } />
			{ scanResults && (
				<Modal
					title={ __( 'Scan Results', 'it-l10n-ithemes-security-pro' ) }
					onRequestClose={ () => setState( { scanResults: undefined } ) }
				>
					{ scanResults.entries ? <SiteScanResults results={ scanResults } showSiteUrl={ false } /> : <MalwareScanResults results={ scanResults } /> }
				</Modal>
			) }
		</div>
	);
}

export default compose( [
	withState( { scanResults: undefined } ),
] )( ScanOnly );
