<?php
namespace Aepro\Modules\TaxonomyBlocks\Skins;

use Aepro\Aepro;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Icons_Manager;
use Aepro\Helper;
use Aepro\Post_Helper;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Plugin;
use WP_Query;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Skin_Term_Post_Loop extends Skin_Base {
	//phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore
	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
	    add_action( 'elementor/element/ae-taxonomy-blocks/section_layout/before_section_end', [ $this, 'register_controls' ] );
		add_action( 'elementor/element/ae-taxonomy-blocks/section_query/after_section_end', [ $this, 'register_posts_controls' ] );
		add_action( 'elementor/element/ae-taxonomy-blocks/section_query/after_section_end', [ $this, 'get_grid_controls' ] );
		add_action( 'elementor/element/ae-taxonomy-blocks/section_carousel/before_section_end', [ $this, 'update_carousel_controls' ] );
		add_action( 'elementor/element/ae-taxonomy-blocks/carousel_style/before_section_start', [ $this, 'item_controls'] );
	}

	public function get_id() {
		return 'term_post_loop';
	}

	public function get_title() {
		return __( 'Term + Post Loop', 'ae-pro' );
	}

	public function update_carousel_controls( Widget_Base $widget ) {


		$this->parent->update_control(
			'arrows_layout',
			[
				'options'   => [
					'inside'  => __( 'Inside', 'ae-pro' ),
					'outside' => __( 'Outside', 'ae-pro' ),
					'with-heading' => __('Align With Title', 'ae-pro'),
				],
			]
		);
	}
    public function register_controls( Widget_Base $widget ) {
		$this->parent = $widget;

		$this->add_control(
			'show_posts',
			[
				'label'        => __( 'Show Posts', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_off'    => __( 'No', 'ae-pro' ),
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$block_layouts[''] = 'Select Block Layout';
		$block_layouts     = $block_layouts + Aepro::$_helper->ae_block_layouts();

		$this->add_control(
			'post_template',
			[
				'label'       => __( 'Block Layout', 'ae-pro' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => $block_layouts,
				'description' => __( Aepro::$_helper->get_widget_admin_note_html( 'Know more about Block Layouts', 'https://wpvibes.link/go/feature-creating-block-layout/' ), 'ae-pro' ),
			]
		);

        $this->add_control(
			'title_heading',
			[
				'label' => __( 'Title', 'ae-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'title_html_tag',
			[
				'label'     => __( 'Title HTML Tag', 'ae-pro' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'h1'  => 'H1',
					'h2'  => 'H2',
					'h3'  => 'H3',
					'h4'  => 'H4',
					'h5'  => 'H5',
					'h6'  => 'H6',
					'div' => 'div',

				],
				'default'   => 'h3',
			]
		);
        $this->add_control(
			'enable_link',
			[
				'label'        => __( 'Enable Link', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_off'    => __( 'No', 'ae-pro' ),
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'open_title_new_tab',
			[
				'label'        => __( 'Open in New Tab', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_off'    => __( 'No', 'ae-pro' ),
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'   => [
					$this->get_control_id( 'enable_link')	=>	'yes',
				],
			]
		);
        $this->add_control(
			'desc_heading',
			[
				'label' => __( 'Description', 'ae-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'show_description',
			[
				'label'        => __( 'Show Description', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_off'    => __( 'No', 'ae-pro' ),
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
        $this->add_control(
			'desc_html_tag',
			[
				'label'     => __( 'HTML Tag', 'ae-pro' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'h1'  => 'H1',
					'h2'  => 'H2',
					'h3'  => 'H3',
					'h4'  => 'H4',
					'h5'  => 'H5',
					'h6'  => 'H6',
					'div' => 'div',
                    'p'   => 'p',
				],
				'default'   => 'p',
                'condition' => [
					$this->get_control_id( 'show_description' ) => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'term_block_heading',
			[
				'label' => __( 'Term Archive Link', 'ae-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'view_more',
			[
				'label'        => __( 'Archive Link', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_off'    => __( 'Hide', 'ae-pro' ),
				'label_on'     => __( 'Show', 'ae-pro' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'view_more_text',
			[
				'label'       => __( 'Button Text', 'ae-pro' ),
				'type'        => Controls_Manager::TEXT,
				'default' => __( 'View All', 'ae-pro' ),
				'condition'   => [
					$this->get_control_id( 'view_more')	=>	'yes',
				],
			]
		);

		$this->add_control(
			'open_archive_new_tab',
			[
				'label'        => __( 'Open in New Tab', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_off'    => __( 'No', 'ae-pro' ),
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'   => [
					$this->get_control_id( 'view_more')	=>	'yes',
				],
			]
		);


        // $this->add_control(
		// 	'enable_accordion',
		// 	[
		// 		'label'        => __( 'Enable Accordion', 'ae-pro' ),
		// 		'type'         => Controls_Manager::SWITCHER,
		// 		'label_off'    => __( 'No', 'ae-pro' ),
		// 		'label_on'     => __( 'Yes', 'ae-pro' ),
		// 		'return_value' => 'yes',
		// 		'default'      => '',
        //         'separator'        => 'before',
		// 	]
		// );



        // $this->add_control(
		// 	'icon',
		// 	[
		// 		'label'            => __( 'Icon', 'ae-pro' ),
		// 		'type'             => Controls_Manager::ICONS,

		// 		'default'          => [
		// 			'value'   => 'fas fa-plus',
		// 			'library' => 'fa-solid',
		// 		],
        //         'condition' => [
		// 			$this->get_control_id( 'enable_accordion' ) => [ 'yes' ],
		// 		],
		// 	]
		// );

		// $this->add_control(
		// 	'active_icon',
		// 	[
		// 		'label'            => __( 'Active Icon', 'ae-pro' ),
		// 		'type'             => Controls_Manager::ICONS,
		// 		'default'          => [
		// 			'value'   => 'fas fa-minus',
		// 			'library' => 'fa-solid',
		// 		],
        //         'condition' => [
		// 			$this->get_control_id( 'enable_accordion' ) => [ 'yes' ],
		// 		],
		// 	]
		// );

		// $this->add_control(
		// 	'accordion_transition_speed',
		// 	[
		// 		'label'   => __( 'Transition Speed', 'ae-pro' ),
		// 		'type'    => Controls_Manager::SLIDER,
		// 		'default' => [
		// 			'unit' => 'px',
		// 			'size' => 300,
		// 		],
		// 		'range'   => [
		// 			'px' => [
		// 				'min'  => 300,
		// 				'max'  => 1000,
		// 				'step' => 100,
		// 			],
		// 		],
        //         'condition' => [
		// 			$this->get_control_id( 'enable_accordion' ) => [ 'yes' ],
		// 		],

		// 	]
		// );

        // $this->add_control(
		// 	'enable_toggle_button',
		// 	[
		// 		'label'        => __( 'Enable Toggle Button', 'ae-pro' ),
		// 		'type'         => Controls_Manager::SWITCHER,
		// 		'default'      => '',
		// 		'label_on'     => __( 'Yes', 'ae-pro' ),
		// 		'label_off'    => __( 'No', 'ae-pro' ),
		// 		'return_value' => 'yes',
		// 		'condition' => [
		// 			$this->get_control_id( 'enable_accordion' ) => [ 'yes' ],
		// 		],
		// 	]
		// );

		// $this->add_control(
		// 	'expand_button_text',
		// 	[
		// 		'label'       => __( 'Expend Text', 'ae-pro' ),
		// 		'type'        => Controls_Manager::TEXT,
		// 		'default' => __( 'Expand All', 'ae-pro' ),
		// 		'condition'   => [
		// 			$this->get_control_id( 'enable_toggle_button')	=>	'yes',
		// 			$this->get_control_id( 'enable_accordion' ) => [ 'yes' ],
		// 		],
		// 	]
		// );
		// $this->add_control(
		// 	'collapse_button_text',
		// 	[
		// 		'label'       => __( 'Collapse Text', 'ae-pro' ),
		// 		'type'        => Controls_Manager::TEXT,
		// 		'default' => __( 'Collapse All', 'ae-pro' ),
		// 		'condition'   => [
		// 			$this->get_control_id( 'enable_toggle_button')	=>	'yes',
		// 			$this->get_control_id( 'enable_accordion' ) => [ 'yes' ],
		// 		],
		// 	]
		// );

		// $this->add_control(
		// 	'toggle_button_separator',
		// 	[
		// 		'label'       => __( 'Separator', 'ae-pro' ),
		// 		'type'        => Controls_Manager::TEXT,
		// 		'default' => __( ' | ', 'ae-pro' ),
		// 		'condition'   => [
		// 			$this->get_control_id( 'enable_toggle_button')	=>	'yes',
		// 			$this->get_control_id( 'enable_accordion' ) => [ 'yes' ],
		// 		],
		// 	]
		// );



        // $this->add_control(
		// 	'icon_align',
		// 	[
		// 		'label'       => __( 'Alignment', 'ae-pro' ),
		// 		'type'        => Controls_Manager::CHOOSE,
		// 		'options'     => [
		// 			'left' => [
		// 				'title' => __( 'Start', 'ae-pro' ),
		// 				'icon'  => 'eicon-h-align-left',
		// 			],
		// 			'right' => [
		// 				'title' => __( 'End', 'ae-pro' ),
		// 				'icon'  => 'eicon-h-align-right',
		// 			],
		// 		],
		// 		'default'     => is_rtl() ? 'right' : 'left',
		// 		'toggle'      => false,
		// 		'label_block' => false,
		// 	]
		// );
    }

	public function register_posts_controls(){

		$this->start_controls_section(
			'section_posts',
			[
				'label' => __( 'Posts', 'ae-pro' ),
				'condition' => [
					'_skin' => 'term_post_loop',
					$this->get_control_id( 'show_posts' ) => [ 'yes' ],
				]
			]
		);

		$this->add_control(
			'content_layout',
			[
				'label'     => __( 'Layout', 'ae-pro' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'grid'     => __( 'Grid', 'ae-pro' ),
					'carousel' => __( 'Carousel', 'ae-pro' ),
				],
				'default'   => 'grid',
                'prefix_class' => 'ae-tb-layout-',
                'render_type' => 'template',
			]
		);

		$this->add_control(
			'author_query_heading',
			[
				'label'     => __( 'Author', 'ae-pro' ),
				'type'      => Controls_Manager::HEADING,
			]
		);

		$this->start_controls_tabs( 'author_query_tabs' );

		$this->start_controls_tab(
			'tab_author_include',
			[
				'label'     => __( 'Include', 'ae-pro' ),
			]
		);

		$this->add_control(
			'include_author_ids',
			[
				'label'       => 'Authors',
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'label_block' => true,
				'show_label'  => false,
				'placeholder' => __( 'Enter Author ID Separated by Comma', 'ae-pro' ),
				'options'     => Post_Helper::instance()->get_authors(),
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_author_exclude',
			[
				'label'     => __( 'Exclude', 'ae-pro' ),
			]
		);

		$this->add_control(
			'exclude_author_ids',
			[
				'label'       => 'Authors',
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'label_block' => true,
				'show_label'  => false,
				'placeholder' => __( 'Enter Author ID Separated by Comma', 'ae-pro' ),
				'options'     => Post_Helper::instance()->get_authors(),
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'orderby',
			[
				'label'           => __( 'Order By', 'ae-pro' ),
				'type'            => Controls_Manager::SELECT,
				'content_classes' => 'ae_conditional_fields',
				'default'         => 'post_date',
				'options'         => [
					'post_date'      => __( 'Date', 'ae-pro' ),
					'post_title'     => __( 'Title', 'ae-pro' ),
					'menu_order'     => __( 'Menu Order', 'ae-pro' ),
					'rand'           => __( 'Random', 'ae-pro' ),
					'meta_value'     => __( 'Custom Field', 'ae-pro' ),
					'meta_value_num' => __( 'Custom Field (Numeric)', 'ae-pro' ),
				],
			]
		);

		$this->add_control(
			'orderby_metakey',
			[
				'label'       => __( 'Meta Key Name', 'ae-pro' ),
				'tyoe'        => Controls_Manager::TEXT,
				'description' => __( 'Custom Field Key', 'ae-pro' ),
				'condition'   => [
					'orderby' => [ 'meta_value', 'meta_value_num' ],
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => __( 'Order', 'ae-pro' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'desc',
				'options'   => [
					'asc'  => __( 'ASC', 'ae-pro' ),
					'desc' => __( 'DESC', 'ae-pro' ),
				],
			]
		);

		$this->add_control(
			'offset',
			[
				'label'       => __( 'Offset', 'ae-pro' ),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 0,
				'description' => __( 'Use this setting to skip over posts (e.g. \'2\' to skip over 2 posts).', 'ae-pro' ),
			]
		);

        $this->add_control(
			'posts_count',
			[
				'label'          => __( 'Post Count', 'ae-pro' ),
				'type'           => Controls_Manager::NUMBER,
				'default'        => 6,
			]
		);

		$this->add_control(
			'query_filter',
			[
				'label'       => __( 'Query Filter', 'ae-pro' ),
				'type'        => Controls_Manager::TEXT,
				'description' => __( Aepro::$_helper->get_widget_admin_note_html( '<span style="color:red">Danger Ahead!!</span> It is a developer oriented feature. Only use if you know how exaclty WordPress queries and filters works.', 'https://wpvibes.link/go/feature-post-blocks-query-filter', 'Read Instructions' ), 'ae-pro' ),
			]
		);

		$this->end_controls_section();
	}

    public function get_grid_controls(Widget_Base $widget){

        $this->parent = $widget;
        $this->start_controls_section(
			'grid_setting',
			[
				'label' => __( 'Post Grid', 'ae-pro' ),
                'condition' =>  [
                    $this->get_control_id( 'content_layout' ) => 'grid'
                ]
			]
		);

		$this->add_responsive_control(
			'columns',
			[
				'label'           => __( 'Columns', 'ae-pro' ),
				'type'            => Controls_Manager::NUMBER,
				'desktop_default' => '3',
				'tablet_default'  => '2',
				'mobile_default'  => '1',
				'min'             => 1,
				'max'             => 12,
				'selectors'       => [
					'{{WRAPPER}} .ae-tb-posts-collection' => 'grid-template-columns: repeat({{VALUE}}, minmax(0, 1fr)); display:grid',
				],
			]
		);

		$this->add_responsive_control(
			'item_col_gap',
			[
				'label'     => __( 'Column Gap', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default'   => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-tb-posts-collection' => 'column-gap: {{SIZE}}{{UNIT}}; grid-column-gap: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'item_row_gap',
			[
				'label'     => __( 'Row Gap', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default'   => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-tb-posts-collection' => 'row-gap: {{SIZE}}{{UNIT}}; grid-row-gap: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->end_controls_section();
    }

    public function item_controls(Widget_Base $widget){
        $this->parent = $widget;
        $this->start_controls_section(
			'item_setting',
			[
				'label' => __( 'Layout', 'ae-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
                // 'condition' =>  [
                //     $this->get_control_id( 'content_layout' ) => 'grid'
                // ]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'item_bg',
				'label'    => __( 'Item Background', 'ae-pro' ),
				'types'    => [ 'none', 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .ae-accordion-item',
				'default'  => '#fff',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'item',
				'label'    => __( 'Border', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-accordion-item',
			]
		);

		$this->add_control(
			'border_radius_item',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-accordion-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow:hidden;',
				],
			]
		);

		$this->add_responsive_control(
			'padding_item',
			[
				'label'      => __( 'Padding', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-accordion-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'margin_item',
			[
				'label'     => __( 'Spacing', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .ae-accordion-item:not(:first-of-type)' => 'margin-top: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'label'    => __( 'Item Shadow', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-accordion-item',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'title_setting',
			[
				'label' => __( 'Title', 'ae-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'term_title_typography',
				'label' => __( 'Typography', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-accordion-item .ae-term-blocks-title',
			]
		);

		$this->start_controls_tabs(
			'term_title_style_tabs'
		);

		$this->start_controls_tab(
			'term_title_style_normal',
			[
				'label' => __( 'Normal', 'ae-pro' ),
			]
		);

		$this->add_control(
			'term_title_color',
			[
				'label' => __( 'Title Color', 'ae-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-blocks-title a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'term_title_bg_color',
			[
				'label' => __( 'Backgrond Color', 'ae-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-tab-title-wrapper' => 'background-color: {{VALUE}}',
				],
			]
		);



		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'term_title_border',
				'label'    => __( 'Border', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-accordion-item .ae-term-tab-title-wrapper',
			]
		);

		$this->add_control(
			'term_title_border_radius',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-tab-title-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow:hidden;',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'term_title_style_hover',
			[
				'label' => __( 'Hover', 'ae-pro' ),
			]
		);

		$this->add_control(
			'term_title_color_hover',
			[
				'label' => __( 'Title Color', 'ae-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-tab-title-wrapper:hover a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'term_title_bg_color_hover',
			[
				'label' => __( 'Background Color', 'ae-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-tab-title-wrapper:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'term_title_border_color_hover',
			[
				'label' => __( 'Border Color', 'ae-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-tab-title-wrapper:hover' => 'border-color: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'term_title_border_radius_hover',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-tab-title-wrapper:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow:hidden;',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'term_title_align',
			[
				'label' => __( 'Alignment', 'ae-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => esc_html__( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],

				'default' => 'left',
				'selectors'	=>	[
					'{{WRAPPER}} .ae-accordion-item .ae-term-blocks-title' => 'text-align : {{VALUE}};'
				],
				'toggle' => true,
			]
		);

		$this->add_responsive_control(
			'term_title_padding',
			[
				'label'      => __( 'Padding', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-tab-title-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'term_title_margin',
			[
				'label'      => __( 'Margin', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-tab-title-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'term_title_nav_heading',
			[
				'label' => __( 'Navigation', 'ae-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					$this->get_control_id( 'content_layout' ) => 'carousel',
					'arrows_layout' => 'with-heading',
					$this->get_control_id( 'term_title_align!' ) => 'center',
				]
			]
		);

		$this->add_responsive_control(
			'term_title_nav_position',
			[
				'label' => __( 'Position', 'ae-pro' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'row' => __( 'After Title', 'ae-pro' ),
					'row-reverse' => __( 'Before Title', 'ae-pro' ),
				],
				'default' => 'row',
				'selectors'	=>	[
					'{{WRAPPER}} .ae-term-tab-title-wrapper' => 'flex-direction : {{VALUE}};'
				],
				'prefix_class' => 'ae-term-title-nav-pos-',
				'condition' => [
					$this->get_control_id( 'content_layout' ) => 'carousel',
					'arrows_layout' => 'with-heading',
				]
			]
		);

		$this->add_control(
			'term_title_nav_spacing',
			[
				'label' => __( 'Spacing', 'ae-pro' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
			 			'unit' => 'px',
			 			'size' => 10,
			 		],
			 		'range'   => [
			 			'px' => [
			 				'min'  => 0,
			 				'max'  => 100,
			 				'step' => 1,
			 			],
			 	],
				'selectors'  => [
					'{{WRAPPER}}.ae-term-title-nav-pos-row .ae-accordion-item .ae-swiper-button-wrapper' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}.ae-term-title-nav-pos-row-reverse .ae-accordion-item .ae-swiper-button-wrapper' => 'margin-right: {{SIZE}}{{UNIT}};',

				],
				'condition' => [
					$this->get_control_id( 'content_layout' ) => 'carousel',
					'arrows_layout' => 'with-heading',
					$this->get_control_id( 'term_title_align!' ) => 'center',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'desc_setting',
			[
				'label' => __( 'Description', 'ae-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
                'condition' =>  [
                    $this->get_control_id( 'show_description' ) => 'yes'
                ]
			]
		);

		$this->add_control(
			'term_desc_color',
			[
				'label' => __( 'Color', 'ae-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-desc' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'term_desc_typography',
				'label' => __( 'Typography', 'ae-pro' ),
				// 'global'	=>	[
				// 	'default'	=>	Global_Typography::TYPOGRAPHY_TEXT,
				// ],
				'selector' => '{{WRAPPER}} .ae-accordion-item .ae-term-desc',
			]
		);

		$this->add_responsive_control(
			'desc_title_align',
			[
				'label' => __( 'Alignment', 'ae-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => esc_html__( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'elementor' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'default' => 'left',
				'selectors'	=>	[
					'{{WRAPPER}} .ae-accordion-item .ae-term-desc' => 'text-align : {{VALUE}};'
				],
				'toggle' => true,
			]
		);

		$this->add_responsive_control(
			'term_desc_padding',
			[
				'label'      => __( 'Padding', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'term_desc_spacing',
			[
				'label'      => __( 'Margin', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-accordion-item .ae-term-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'posts_style',
			[
				'label'     => __( 'Posts', 'ae-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' =>  [
                    $this->get_control_id( 'show_posts' ) => 'yes'
                ]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'posts_item_bg',
				'label'    => __( 'Background', 'ae-pro' ),
				'types'    => [ 'none', 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .ae-term-blocks-content .ae-post-item-inner',
				'default'  => '#fff',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'posts_border',
				'label'    => __( 'Border', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-term-blocks-content .ae-post-item-inner',
			]
		);

		$this->add_control(
			'posts_border_radius',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-term-blocks-content .ae-post-item-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow:hidden;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'posts_box_shadow',
				'label'    => __( 'Item Shadow', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-term-blocks-content .ae-post-item-inner',
			]
		);

		$this->add_responsive_control(
			'posts_padding',
			[
				'label'      => __( 'Padding', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-layout-grid .ae-accordion-item .ae-tb-outer-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .ae-layout-carousel .ae-accordion-item .ae-swiper-outer-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'posts_spacing',
			[
				'label'      => __( 'Margin', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-layout-grid .ae-accordion-item .ae-tb-outer-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .ae-layout-carousel .ae-accordion-item .ae-swiper-outer-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'term_button_style',
			[
				'label' => esc_html__( 'Button', 'elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'	=>	[
					$this->get_control_id('view_more') => 'yes'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'term_button_typography',
				'label' => __( 'Typography', 'ae-pro' ),
				// 'global' => [
				// 	'default' => Global_Typography::TYPOGRAPHY_ACCENT,
				// ],
				'selector' => '{{WRAPPER}} .ae-term-button',
			]
		);


		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'text_shadow',
				'selector' => '{{WRAPPER}} .ae-term-button',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => esc_html__( 'Text Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ae-term-button' => 'fill: {{VALUE}}; color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__( 'Background', 'elementor' ),
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .ae-term-button',
				'fields_options' => [
					'background' => [
						'default' => 'classic',
					],
					'color' => [
						'global' => [
							'default' => Global_Colors::COLOR_ACCENT,
						],
					],
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'term_button_border',
				'selector' => '{{WRAPPER}} .ae-term-button',
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ae-term-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .ae-term-button',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor' ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label' => esc_html__( 'Text Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-term-button:hover, {{WRAPPER}} .ae-term-button:focus' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ae-term-button:hover svg, {{WRAPPER}} .ae-term-button:focus svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'button_background_hover',
				'label' => esc_html__( 'Background', 'elementor' ),
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .ae-term-button:hover, {{WRAPPER}} .ae-term-button:focus',
				'fields_options' => [
					'background' => [
						'default' => 'classic',
					],
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label' => esc_html__( 'Border Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,
				'condition'	=>	[
					$this->get_control_id('term_button_border_border!') => ''
				],
				'selectors' => [
					'{{WRAPPER}} .ae-term-button:hover' => 'border-color: {{VALUE}};',
					 '{{WRAPPER}} .ae-term-button:focus' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'border_radius_hover',
			[
				'label' => esc_html__( 'Border Radius', 'elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ae-term-button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow_hover',
				'selector' => '{{WRAPPER}} .ae-term-button:hover',

			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();




		$this->add_control(
			'term_button_align',
			[
				'label' => __( 'Alignment', 'ae-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'separator' => 'before',
				'options' => [
					'left'    => [
						'title' => esc_html__( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'elementor' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'default'	=>	'left',
				'prefix_class' => 'ae-term-button-align-',
			]
		);

		$this->add_responsive_control(
			'term_button_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .ae-term-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'term_button_margin',
			[
				'label' => esc_html__( 'Margin', 'elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .ae-term-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

    }




    public function render() {
        $settings           = $this->parent->get_settings_for_display();
        $content_layout     = $this->get_instance_value('content_layout');
        $title_tag          = $this->get_instance_value('title_html_tag');
		$tab_icon           = $this->get_instance_value( 'icon' );
		$tab_active_icon    = $this->get_instance_value( 'active_icon' );
        $show_desc          = $this->get_instance_value('show_description');
        $show_posts         = $this->get_instance_value('show_posts');
        //$post_count         = $this->get_instance_value('posts_count');
        $enable_toggle      = $this->get_instance_value('enable_accordion');
        $enable_link        = $this->get_instance_value('enable_link');
        $view_more          = $this->get_instance_value('view_more');
		$toggle_button  	= $this->get_instance_value('enable_toggle_button');
		$posts_args = [];
        $settings['direction'] = 'horizontal';
        if($content_layout == 'carousel'){
            $swiper_data = $this->get_swiper_data($settings);
        }
		$blank = '';
		$target  = $this->get_instance_value('open_title_new_tab');
		if($target == 'yes'){
			$blank = '_blank';
		}

		if( $settings['_skin'] == 'term_post_loop' && $show_posts == 'yes' ){
			// Include Author
			$inc_author = $this->get_instance_value('include_author_ids');
			if ( is_array( $inc_author ) && count( $inc_author ) ) {
				$posts_args['author'] = implode( ',', $inc_author );
			}
			//Exclude By Author
			$exc_author = $this->get_instance_value('exclude_author_ids');
			if ( is_array( $exc_author ) && count( $exc_author ) ) {
				$posts_args['author__not_in'] = $exc_author;
			}

			//Exclude by offset
			$posts_args['offset'] = $this->get_instance_value('offset');

			// Ordering Parameters
			$posts_args['orderby'] = $this->get_instance_value('orderby');
			$posts_args['order']   = $this->get_instance_value('order');

			if ( $posts_args['orderby'] === 'meta_value' || $posts_args['orderby'] === 'meta_value_num' ) {
				$posts_args['meta_key'] = $this->get_instance_value('orderby_metakey');
			}

			// Post Count
			if ( $this->get_instance_value('posts_count') ) {
				$posts_args['posts_per_page'] = $this->get_instance_value('posts_count');
			}
		}

		// $toggle_button  =  $this->get_instance_value('enable_toggle_button');

		$has_icon = ( ! empty( $tab_icon['value'] ) );
        $terms = Aepro::$_helper->ae_taxonomy_terms( $settings['ae_taxonomy'], $settings );


        $this->parent->add_render_attribute( 'term-list-wrapper', 'class', 'ae-term-skin-' . $settings['_skin'] );
		$this->parent->add_render_attribute( 'term-list-wrapper', 'class', 'ae-term-list-wrapper' );

		// if(!is_archive()){
		// 	$this->parent->add_render_attribute( 'term-list-item', 'class', 'ae-term-list-item' );
		// }
		$this->parent->add_render_attribute( 'term-list-item-inner', 'class', 'ae-term-list-item-inner' );

		// $this->parent->add_render_attribute( 'taxonomy-widget-wrapper', 'data-pid', get_the_ID() );
		//$this->parent->add_render_attribute( 'taxonomy-widget-wrapper', 'data-wid', $this->parent->get_id() );
		$this->parent->add_render_attribute( 'taxonomy-widget-wrapper', 'data-source', $settings['ae_taxonomy'] );
        if($content_layout == 'carousel'){
            $this->parent->add_render_attribute( 'taxonomy-widget-wrapper', 'data-swiper-settings', wp_json_encode( $swiper_data ) );
        }

		$this->parent->add_render_attribute( 'taxonomy-widget-wrapper', 'class', [ 'ae-taxonomy-widget-wrapper', 'ae-layout-'.$content_layout, 'ae-toggle-'.$enable_toggle] );
        if($content_layout == 'carousel'){
            $this->parent->add_render_attribute( 'taxonomy-widget-wrapper', 'class', 'ae-swiper-outer-wrapper');
        }
		if($settings['arrows_layout'] === 'with-heading'){
			$this->parent->add_render_attribute( 'taxonomy-widget-wrapper', 'class', 'ae-swiper-nav-align-title' );
		}
        $transition_speed = $this->get_instance_value( 'accordion_transition_speed' );
        $this->parent->add_render_attribute( 'collection', 'class', 'ae-term-collection' );
        $this->parent->add_render_attribute(
			'collection',
			[
				'class'                 => 'elementor-accordion ae-accordion',
				'role'                  => 'tablist',
				//'data-transition-speed' => $transition_speed['size'],
			]
		);
        ?>
        <div <?php echo $this->parent->get_render_attribute_string( 'taxonomy-widget-wrapper' ); ?>>
			<div <?php echo $this->parent->get_render_attribute_string( 'term-list-wrapper' ); ?>>
                <div <?php echo $this->parent->get_render_attribute_string( 'collection' ); ?> >
				<?php
						if($toggle_button === 'yes' && $enable_toggle == 'yes'){
							?>
								<div class="ae-accordion-tb-wrapper">
									<button class="ae-accordion-toggle-button expand" data-role="expand"><?php echo $this->get_instance_value('expand_button_text'); ?></button>
									<span> <?php echo $this->get_instance_value('toggle_button_separator'); ?> </span>
									<button class="ae-accordion-toggle-button collapse" data-role="collapse"><?php echo $this->get_instance_value('collapse_button_text'); ?></button>
								</div>
							<?php
						}
                        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                            $count = count( $terms );
                            $i     = 0;
                            $tab_count       = 0;
                            $title_class   = 'ae-term-blocks-title';
                            $content_class = 'elementor-clearfix ae-term-blocks-content';
                            if($enable_toggle == 'yes'){
                                $title_class .= ' elementor-tab-title ae-tab-title';
                               $content_class .= ' ae-tab-content';
                            }
                            foreach ( $terms as $term ) {
                                $title = $term->name;
                                $term_desc = $term->description;
                                $term_link = get_term_link($term->term_id);
                                $index = wp_rand();
                                $tab_no = $index + 1;
                                (int)$tab_count++;
                                // if ( $tab_count == 1 ) {
                                //     $title_class   = $title_class . ' ae-active';
                                //     $content_class = $content_class . ' ae-active';
                                // }
                                $tab_title = $term->name;
                                $i++;
                                $this->parent->set_render_attribute(
                                    'ae-term-blocks-accordion-title',
                                    [
                                        'id'            => 'ae-tab-title-' . $tab_no . $tab_count,
                                        't_id'          => $tab_no . $tab_count,
                                         'class'         => $title_class,
                                        'data-tab'      => $tab_count,
                                        'role'          => 'tab',
                                        'aria-controls' => 'ae-tab-content-' . $tab_no . $tab_count,
                                    ]
                                );
                                $this->parent->set_render_attribute(
                                    'ae-term-blocks-accordion-content',
                                    [
                                        'id'              => 'ae-tab-content-' . $tab_no . $tab_count,
                                        't_id'            => $tab_no . $tab_count,
                                        'class'           => $content_class,
                                        'data-tab'        => $tab_count,
                                        'role'            => 'tabpanel',
                                        'aria-labelledby' => 'ae-tab-title-' . $tab_no . $tab_count,
                                    ]
                                );
                                if($enable_toggle == ''){
                                    $this->parent->set_render_attribute(
                                        'ae-term-blocks-accordion-content', 'style' , 'display:block');
                                }

                                $this->parent->set_render_attribute(
                                    'ae-term-blocks-accordion-content', 'class' , $content_class);
                                $this->parent->set_render_attribute(
                                    'ae-term-blocks-accordion-title', 'class' , $title_class);
                                ?>
                                <div class="ae-accordion-item ae-term-<?php echo $term->term_id; ?> elementor-element-<?php echo $index; ?>" data-term-id="ae-term-<?php echo $term->term_id;?>" data-item-id="<?php echo $index; ?>">
                                    <div class="ae-term-tab-title-wrapper">
										<<?php echo $title_tag; ?> <?php echo $this->parent->get_render_attribute_string( 'ae-term-blocks-accordion-title' ); ?>>
											<?php if ( $has_icon && $enable_toggle == 'yes') : ?>
												<span class="ae-accordion-icon ae-accordion-icon-<?php echo esc_attr( $this->get_instance_value( 'icon_align' ) ); ?>" aria-hidden="true">
													<span class="ae-accordion-icon-closed"><?php Icons_Manager::render_icon( $tab_icon ); ?></span>
													<span class="ae-accordion-icon-opened"><?php Icons_Manager::render_icon( $tab_active_icon ); ?></span>
												</span>
											<?php endif;?>
											<!-- <div class="ae-term-title-wrap"> -->
											<?php
											if($enable_link == 'yes'){
												?>
													<a href="<?php echo $term_link; ?>" class="ae-term-title" target="<?php echo $blank; ?>"><?php echo $title; ?></a>
												<?php
											}else{
												?>
													<span class="ae-term-title"><?php echo $title; ?></span>
												<?php
											} ?>
											<!-- </div> -->
										</<?php echo $title_tag; ?>>
										<?php if($settings['arrows_layout'] == 'with-heading' && $content_layout == 'carousel' && $show_posts == 'yes'){
												$this->get_swiper_arrows($settings);
											} ?>
									</div>

                                    <div <?php echo $this->parent->get_render_attribute_string( 'ae-term-blocks-accordion-content' ); ?>>
                                        <?php if($show_desc == 'yes' && !empty($term_desc)){?>
                                            <<?php echo $this->get_instance_value( 'desc_html_tag' ); ?> class="ae-term-desc">
                                                <?php echo $term_desc; ?>
                                            </<?php echo $this->get_instance_value( 'desc_html_tag' ); ?>>
                                        <?php } ?>
                                        <?php if($show_posts == 'yes'){
                                            $posts =  $this->get_term_posts($posts_args, $term, $settings['ae_taxonomy']);
											if(empty($this->get_instance_value('post_template'))){
													$this->if_layout_is_blank();
											}
                                            if(!empty($posts) && !empty($this->get_instance_value('post_template'))){
                                                if($content_layout == 'grid'){
                                                    $this->render_grid_layout($posts, $settings);
                                                }else{
                                                    $this->render_carousel_layout($posts, $settings);
                                                }
                                            }
                                        }
                                        if($view_more == 'yes'){
                                            $this->render_button($settings,$term_link);
                                        } ?>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                    ?>
                </div>
            </div>
        </div>
        <?php
    }

    public function get_term_posts($posts_args, $term, $taxonomy){
		if ( $taxonomy === 'child_of_current' ) {
			if ( \Elementor\Plugin::instance()->editor->is_edit_mode() ) {
				$preview_term = Aepro::$_helper->get_preview_term_data();
				if ( isset( $preview_term['prev_term_id'] ) ) {
					$taxonomy = $preview_term['taxonomy'];
					$parent   = $preview_term['prev_term_id'];
				}
			} else {
				// get child of current term
				$current_term = get_queried_object();
				$taxonomy     = $current_term->taxonomy;
				$parent       = $current_term->term_id;
			}
		}

        $args = [
            'post_type' => 'any',
            'tax_query' => array(
                array(
                    'taxonomy' => $taxonomy,
                    'field'    => 'slug',
                    'terms'    => $term->slug,
                )
            )
        ];

		$args = array_merge($args, $posts_args);
		// Run Query Filter
		$args = apply_filters( "aepro/taxonomy_blocks/query/{$this->get_instance_value('query_filter')}", $args );
        $query_data =  new WP_Query($args);
        return $query_data->posts;

    }

    public function render_item($term){

    }

    public function render_grid_layout($posts,$settings){
        $post_template = $this->get_instance_value('post_template');
        $this->parent->set_render_attribute( 'outer-wrapper', 'class', 'ae-tb-outer-wrapper ae-height-100' );
		$this->parent->set_render_attribute( 'outer-wrapper', 'data-pid', get_the_ID() );
		$this->parent->set_render_attribute( 'outer-wrapper', 'data-wid', $this->parent->get_id() );
        $this->parent->set_render_attribute( 'collection', 'class', 'ae-tb-posts-collection' );
        $item_classes = array_merge( [ 'ae-post-item', 'ae-post-item-' . $this->parent->get_id() ]);
		$item_inner_classes = [ 'ae-post-item-inner' ];
        $this->parent->set_render_attribute( 'item', 'class', $item_classes );
        $this->parent->set_render_attribute( 'item-inner', 'class', $item_inner_classes );
        $with_css = false;
		if ( Plugin::instance()->editor->is_edit_mode() ) {
			$with_css = true;
		}

        ?>
        <div <?php echo $this->parent->get_render_attribute_string( 'outer-wrapper' ); ?> >
            <div <?php echo $this->parent->get_render_attribute_string( 'collection' ); ?> >
                <?php
                global $post;
                foreach( $posts as $current_post ){
                    $post = $current_post; // Set $post global variable to the current post object
                    setup_postdata( $post ); // Set up "environment" for template tags
                    ?>
                        <article <?php echo $this->parent->get_render_attribute_string( 'item' ); ?> >
                            <div <?php echo $this->parent->get_render_attribute_string( 'item-inner' ); ?>>
                                <div class="ae_data elementor elementor-<?php echo get_the_ID(); ?>">
                                    <?php echo Plugin::instance()->frontend->get_builder_content($post_template, $with_css); ?>
                                </div>
                            </div>
                         </article>
                    <?php
                };
                wp_reset_postdata();
                ?>
            </div>
        </div>
        <?php
    }

    public function render_carousel_layout($posts, $settings){
       $post_template = $this->get_instance_value('post_template');
        // $pagination_type   = $settings['ptype'];
		// $navigation_button = $settings['navigation_button'];
		// $scrollbar         = $settings['scrollbar'];
		$outer_class = ['ae-swiper-outer-wrapper', 'ae-carousel-yes'];
		// $arrows_layout         = $settings['arrows_layout'];
		$settings['direction'] = 'horizontal';

		if ( $settings['arrows_layout'] === 'inside' ) {
			$outer_class[] = 	'ae-hpos-' . $settings['arrow_horizontal_position'];
			$outer_class[] = 	'ae-vpos-' . $settings['arrow_vertical_position'];
		}

		if( $settings['auto_height'] !== 'yes' ){
			$outer_class[] = 'ae-height-100';
		}

        $this->parent->set_render_attribute( 'outer-wrapper', 'class', $outer_class );
		// if ( $settings['arrows_layout'] === 'inside' ) {
		// 	$this->parent->set_render_attribute( 'outer-wrapper', 'class', 'ae-hpos-' . $settings['arrow_horizontal_position'] );
		// 	$this->parent->set_render_attribute( 'outer-wrapper', 'class', 'ae-vpos-' . $settings['arrow_vertical_position'] );
		// }
		//$this->parent->set_render_attribute( 'outer-wrapper', 'data-swiper-settings', wp_json_encode( $swiper_data ) );

		// Collection Attributes
		$this->parent->set_render_attribute( 'collection', 'class', 'ae-post-collection' );
		$this->parent->set_render_attribute( 'collection', 'class', 'ae-swiper-container swiper-container'  );

		//Swiper List Wrapper Attributes
		$this->parent->set_render_attribute( 'post-list-wrapper', 'class', 'ae-post-widget-wrapper ae-swiper-wrapper swiper-wrapper' );
        $item_classes =  [ 'ae-post-item', 'ae-post-item-' . $this->parent->get_id(), 'ae-swiper-slide', 'swiper-slide' ];
        $this->parent->set_render_attribute( 'item', 'class', $item_classes );
        $item_inner_classes = [ 'ae-post-item-inner', 'ae-swiper-slide-wrapper'];
        $this->parent->set_render_attribute( 'item-inner', 'class', $item_inner_classes );
        $with_css = false;
		if ( Plugin::instance()->editor->is_edit_mode() ) {
			$with_css = true;
		}
        ?>
        <div <?php echo $this->parent->get_render_attribute_string( 'outer-wrapper' ); ?> >
            <div <?php echo $this->parent->get_render_attribute_string( 'collection' ); ?> >
                <div <?php echo $this->parent->get_render_attribute_string( 'post-list-wrapper' ); ?> >
                <?php
                    global $post;
                    foreach( $posts as $current_post ){
                        $post = $current_post; // Set $post global variable to the current post object
                        setup_postdata( $post ); // Set up "environment" for template tags
                        ?>
                            <article <?php echo $this->parent->get_render_attribute_string( 'item' ); ?> >
                                <div <?php echo $this->parent->get_render_attribute_string( 'item-inner' ); ?>>
                                    <div class="ae_data elementor elementor-<?php echo get_the_ID(); ?>">
                                        <?php echo Plugin::instance()->frontend->get_builder_content($post_template, $with_css); ?>
                                    </div>
                            </article>
                        <?php
                    };
                wp_reset_postdata();
                ?>
                </div>
                <?php $this->get_swiper_pagination($settings);
                /** Arrows Inside **/
				if ( $settings['navigation_button'] === 'yes' && $settings['arrows_layout'] === 'inside' ) {
					$this->get_swiper_arrows($settings);
				}
                $this->get_swiper_scrollbar($settings);  ?>
            </div>
            <?php
			if ( $settings['navigation_button'] === 'yes' && $settings['arrows_layout'] === 'outside' ) {
				/** Arrows Outside **/
				$this->get_swiper_arrows($settings);
			}
			?>
        </div>
        <?php
    }

    public function get_swiper_pagination($settings) {
		if ( $settings['ptype'] !== '' ) {
			?>
			<div class = "ae-swiper-pagination swiper-pagination"></div>
			<?php
		}
	}

    public function get_swiper_scrollbar($settings) {
		if ( $settings['scrollbar'] === 'yes' ) {
			?>
			<div class = "ae-swiper-scrollbar swiper-scrollbar"></div>
			<?php
		}
	}

    public function get_swiper_arrows	($settings) {
		if ($settings['arrow_horizontal_position'] !== 'center' && ($settings['arrows_layout'] === 'inside' || $settings['arrows_layout'] === 'with-heading') ) {
			?>
			<div class="ae-swiper-button-wrapper">
			<?php
		}
		?>
		<div class = "ae-swiper-button-prev swiper-button-prev">
			<?php
			if ( is_rtl() ) {
				Icons_Manager::render_icon( $settings['arrow_icon_right' ], [ 'aria-hidden' => 'true' ] );
			} else {
				Icons_Manager::render_icon( $settings['arrow_icon_left'], [ 'aria-hidden' => 'true' ] );
			}
			?>
		</div>
		<div class = "ae-swiper-button-next swiper-button-next">
			<?php
			if ( is_rtl() ) {
				Icons_Manager::render_icon( $settings['arrow_icon_left'], [ 'aria-hidden' => 'true' ] );
			} else {
				Icons_Manager::render_icon( $settings['arrow_icon_right'], [ 'aria-hidden' => 'true' ] );
			}
			?>
		</div>
		<?php
		if ( $settings['arrow_horizontal_position'] !== 'center' && ($settings['arrows_layout'] === 'inside' || $settings['arrows_layout'] === 'with-heading') ) {
			?>
			</div>
			<?php
		}
	}

    public function render_button($settings, $link){
		$blank = '';
		$target  = $this->get_instance_value('open_archive_new_tab');

		if($target == 'yes'){
			$blank = '_blank';
		}
        ?>
            <div class="ae-tb-button-wrapper">
                <a href="<?php echo $link;?>" class="ae-term-button" role="button" target ="<?php echo $blank; ?>">
                    <span class="content-wrapper">
                        <span class="button-text" ><?php echo $this->get_instance_value('view_more_text');?></span>
                    </span>
                </a>
            </div>

        <?php
    }

	public function if_layout_is_blank() {
		$post_template = $this->get_instance_value('post_template');
		if ( ! isset( $post_template ) || empty( $post_template ) || get_post_status( $post_template ) !== 'publish' ) {
			if( \Elementor\Plugin::instance()->editor->is_edit_mode() || \Elementor\Plugin::instance()->preview->is_preview_mode() || (isset($_GET['preview']) && $_GET['preview'] === 'true') ) {
				printf( '<div class="message"><p class="%1$s">%2$s</p></div>', esc_attr( 'elementor-alert elementor-alert-warning' ), esc_html( __( "Please select a Block Layout first from 'Content > Layout'", 'ae-pro' ) ) );
			}
		}
	}

}
