<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

// Rank Math Pro License
if ( ! class_exists( 'Rank_Math_Pro_Zhk_SDK' ) ) {
	require_once 'includes/class-rank-math-pro-license.php';
}

// Copy Translations As Content --- seo-by-rank-math
add_action( 'admin_init', 'rank_math_naga_copy_translations' );
function rank_math_naga_copy_translations() {
	if ( is_rtl() ) {
		$locale = 'fa_IR';
		$domain = 'seo-by-rank-math';
		$mofile = $domain . '-' . $locale . '.mo';
		$file1 = plugin_dir_path( __FILE__ ) . 'languages/' . $mofile;
		$file2 = WP_LANG_DIR . '/plugins/' . $mofile;
		$contentx =@ file_get_contents( $file1 );
		$openedfile = fopen( $file2, "w" );
		fwrite( $openedfile, $contentx ) ;
		fclose( $openedfile );
		if ( $contentx !== FALSE ) {
			//var_dump("Text-Domain: $domain - Translations Has Been Copied Successfully!");
		}
	}
}

// Load Translations --- rank-math-pro | rank-math
add_action( 'init', 'rank_math_naga_load_translations' );
function rank_math_naga_load_translations() {
	if ( is_rtl() ) {
		$locale = 'fa_IR';
		$domains = array ('rank-math', 'rank-math-pro');
		foreach ( $domains as $domain ) {
			$mofile = $domain . '-' . $locale . '.mo';
			$path = plugin_dir_path( __FILE__ ) . 'languages/' . $mofile;
			unload_textdomain( $domain );
			load_textdomain( $domain, $path );
		}
	}
}

// Fixing RTL Admin Styles
add_action( 'admin_enqueue_scripts', 'rank_math_naga_admin_css' );
function rank_math_naga_admin_css() {
	if( Rank_Math_Pro_Zhk_SDK::is_activated() === true ) {
		if ( is_rtl() ) {
			wp_enqueue_style( 'rank-math-naga-admin-css', plugin_dir_url( __FILE__ ) . 'css/rank-math-naga-admin.css' );
		}
	}
}

// Fixing Front-End Styles
// add_action( 'wp_enqueue_scripts', 'rank_math_naga_front_css' );
function rank_math_naga_front_css() {
	if( Rank_Math_Pro_Zhk_SDK::is_activated() === true ) {
		if ( is_rtl() ) {
			wp_enqueue_style( 'rank-math-naga-front-css', plugin_dir_url( __FILE__ ) . 'css/rank-math-naga-front.css' );
		}
	}
}

// Disable Options If License is not Valid
add_action( 'admin_init', 'rank_math_pro_naga_disable_options' );
function rank_math_pro_naga_disable_options() {
	if( Rank_Math_Pro_Zhk_SDK::is_activated() !== true ) {
		remove_menu_page( 'rank-math' ); // RankMath
	}
}

// Add NagaTheme Help Sub-Menu Page
add_action( 'admin_menu', 'rank_math_pro_naga_submenu_kb', 100 );
function rank_math_pro_naga_submenu_kb() {
	if ( is_rtl() ) {
		add_submenu_page( 
			'rank-math',
			__('NagaTheme KB', 'rank-math-pro'),
			__('NagaTheme KB', 'rank-math-pro'),
			'manage_options',
			'nagatheme-knowledge-base',
			'rank_math_pro_naga_kb_page'
		);
	}
}
function rank_math_pro_naga_kb_page() {
	if ( is_rtl() ) {
		require_once('includes/nagatheme-kb.php');
	}
}

// Nagatheme Fixing "$title variable required" Issue
if( in_array( 'seo-by-rank-math/rank-math.php', apply_filters( 'active_plugins', get_option( 'active_plugins') ) ) ) {
	$path_to_file = WP_CONTENT_DIR . '/plugins/seo-by-rank-math/vendor/mythemeshop/wordpress-helpers/src/admin/class-page.php';
	$file_contents = file_get_contents($path_to_file);
	$naga_old_string = 'if ( ! $id ) {';
	$naga_new_string = 'if ( false ) {';
	if ( strstr( $file_contents, $naga_old_string ) ) {
		$file_contents = str_replace( $naga_old_string, $naga_new_string, $file_contents );
		file_put_contents($path_to_file, $file_contents);
	}
	$naga_old_string = 'if ( ! $title ) {';
	$naga_new_string = 'if ( false ) {';
	if ( strstr( $file_contents, $naga_old_string ) ) {
		$file_contents = str_replace( $naga_old_string, $naga_new_string, $file_contents );
		file_put_contents($path_to_file, $file_contents);
	}
}

// Rank Math Pro NagaTheme Disable Sensitive Data Encryption
add_filter( 'rank_math/admin/sensitive_data_encryption', '__return_false' );

// Rank Math Pro NagaTheme Update Options - Business Plan
add_action( 'admin_init', 'rank_math_pro_naga_update_options' );
function rank_math_pro_naga_update_options() {
	if( Rank_Math_Pro_Zhk_SDK::is_activated() === true ) {
		update_option( 'rank_math_connect_data', [
			'username'  => 'nagatheme',
			'email'     => 'nagathemedemo@gmail.com',
			'api_key'   => '*********',
			'plan'      => 'business',
			'connected' => true,
		] );
		update_option( 'rank_math_registration_skip', 1 );
	}
}

// Rank Math Pro NagaTheme Activating Pro Options - Analytics and Keywords
add_action( 'init', function() {
	if( Rank_Math_Pro_Zhk_SDK::is_activated() === false ) { return; }
    add_filter( 'pre_http_request', function( $pre, $parsed_args, $url ) {
        if ( strpos( $url, 'https://rankmath.com/wp-json/rankmath/v1/' ) !== false ) {
            $basename = basename( parse_url( $url, PHP_URL_PATH ) );
            if ( $basename == 'siteSettings' ) {
                return [
                    'response' => [ 'code' => 200, 'message' => 'ОК' ],
                    'body'     => json_encode( [
                        'error' => '',
                        'plan'  => 'business',
                        'keywords' => get_option( 'rank_math_keyword_quota', [ 'available' => 10000, 'taken' => 0 ] ),
                        'analytics' => 'on',
                    ] ),
                ];
            } elseif ( $basename == 'keywordsInfo' ) {
                if ( isset( $parsed_args['body']['count'] ) ) {
                    return [
                        'response' => [ 'code' => 200, 'message' => 'ОК' ],
                        'body'     => json_encode( [ 'available' => 10000, 'taken' => $parsed_args['body']['count'] ] ),
                    ];
                }

            } 
            return [ 'response' => [ 'code' => 200, 'message' => 'ОК' ] ];
        }
        return $pre;
    }, 10, 3 );
} );

// End of The Game...