<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

// Rank Math Pro License
if ( ! class_exists( 'f9225301e2cc4a8ab5b2fb129b8b' ) ) {
	require_once __DIR__.'/activatezhk/validate-locked.php';
}

add_action( 'admin_notices', function() {
	if( version_compare(PHP_VERSION, '7.4') < 0 ) {
		if( get_locale() !== 'fa_IR') {
		?>
			<div class="notice notice-error">
				<p>According to 
				<a href="https://wordpress.org/about/requirements/" target="_blank" rel="noopener noreferrer">WordPress Requirements</a> 
				the PHP version of your host Must be at least 7.4 or higher! Please update your host PHP version to be able to use the plugin. 
				<a href="https://nagatheme.com/how-to-change-host-php-version/" target="_blank" rel="noopener noreferrer">Please check this article for more informations!</a></p>
			</div>
		<?php
		} else {
		?>
			<div class="notice notice-error">
				<p>با توجه به 
				<a href="https://wordpress.org/about/requirements/" target="_blank" rel="noopener noreferrer">پیش‌نیازهای ضروری وردپرس</a> 
				نسخه php هاست شما باید حداقل 7.4 یا بالاتر باشد. لطفاً ابتدا نسخه php هاست خود را آپدیت کنید تا افزونه فعال شود. 
				<a href="https://nagatheme.com/how-to-change-host-php-version/" target="_blank" rel="noopener noreferrer">برای اطلاعات بیشتر این مقاله را بررسی کنید!</a></p>
			</div>
		<?php
		}
	} else {
		if( get_locale() !== 'fa_IR') {
		?>
			<div class="notice notice-error">
				<p>Rank Math Pro is Disabled! Rank Math Pro PHP files are encrypted for more performance and security! ionCube or SourceGuardian Loader is required to be installed in your host! 
				<a href="https://nagatheme.com/how-to-install-ioncube-and-sourceguardian-loader/" target="_blank" rel="noopener noreferrer">Please check this article for more informations!</a></p>
			</div>
		<?php
		} else {
		?>
			<div class="notice notice-error">
				<p>افزونه رنک مث پرو غیرفعال شد! کدهای افزونه جهت بهبود عملکرد و امنیت سایت شما، انکریپ شده‌اند! برای اینکه افزونه بتواند فعال شوند، حتماً باید {سورس گاردین لودر} یا {آیون کیوب لودر} بر روی هاست شما فعال باشد! 
				<a href="https://nagatheme.com/how-to-install-ioncube-and-sourceguardian-loader/" target="_blank" rel="noopener noreferrer">برای اطلاعات بیشتر این مقاله را بررسی کنید!</a></p>
			</div>
		<?php
		}
	}
	
	deactivate_plugins( '/seo-by-rank-math-pro/rank-math-pro.php' );
} );
	