<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

function naga_rankmath_php_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<?php
			echo sprintf(
			
				__( 'According to %1$s the PHP version of your host must be at least 7.4 or higher! Please update your host PHP version to be able to activate %2$s and use the pro version. %3$s', 'naga-rankmath-notices' ),
				
				'<a href="https://wordpress.org/about/requirements/" target="_blank" rel="noopener noreferrer">'.__('WordPress Requirements', 'naga-rankmath-notices').'</a>',
				
				basename( plugin_dir_path(  dirname( __FILE__ , 2 ) ) ),
				
				'<a href="https://nagatheme.com/how-to-change-host-php-version/" target="_blank" rel="noopener noreferrer">'.__('Please check this article for more informations!', 'naga-rankmath-notices').'</a>'
				
				);
				
			?>
		</p>
	</div>
	<?php
}

function naga_rankmath_ioncube_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<?php
			echo sprintf(
			
				__( 'Unfortunately, %1$s settings are Disabled! The Product PHP files are encrypted for more performance and security! ionCube Loader is required to be installed in your host! Please contact your hosting support and ask them to install the ioncube loader! %2$s', 'naga-rankmath-notices' ),
				
				basename( plugin_dir_path(  dirname( __FILE__ , 2 ) ) ),
				
				'<a href="https://nagatheme.com/how-to-install-ioncube-and-sourceguardian-loader/" target="_blank" rel="noopener noreferrer">'.__('Please check this article for more informations!', 'naga-rankmath-notices').'</a>'
				
				);
			?>
		</p>
	</div>
	
	<?php
}

function naga_rankmath_ioncube_version_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<?php
			
			echo sprintf(
			
				__( 'Unfortunately, %1$s settings are Disabled! The Product PHP files are encrypted for more performance and security by ioncube! The ioncube loader is active in your host but its version is {%2$s} while it must be at least {11.0.0} so that you can use this product. Please contact your hosting support and ask them to update the ioncube loader! %3$s', 'naga-rankmath-notices' ),
				
				basename( plugin_dir_path(  dirname( __FILE__ , 2 ) ) ),
				
				naga_rankmath_get_ioncube_loader_version(),
				
				'<a href="https://nagatheme.com/how-to-install-ioncube-and-sourceguardian-loader/" target="_blank" rel="noopener noreferrer">'.__('Please check this article for more informations!', 'naga-rankmath-notices').'</a>'
				
				);
				
			?>
		</p>
	</div>
	<?php
}

function naga_rankmath_get_ioncube_loader_version() {
	
	if( function_exists( 'ioncube_loader_version' ) ) {
		
		$ioncube_loader_version = ioncube_loader_version();
		
		return $ioncube_loader_version;
		
	} else {
		
		return __( 'NAN', 'naga-rankmath-notices' );
		
	}
	
}

function naga_rankmath_pro_deactivate_licenses() {
	
	remove_submenu_page( 'rank-math', 'rank-math' );
	
	remove_submenu_page( 'rank-math', 'rank-math-analytics' );
	
	remove_submenu_page( 'rank-math', 'rank-math-options-general' );
	
	remove_submenu_page( 'rank-math', 'rank-math-options-titles' );
	
	remove_submenu_page( 'rank-math', 'rank-math-options-sitemap' );
	
	remove_submenu_page( 'rank-math', 'edit.php?post_type=rank_math_schema' );
	
	remove_submenu_page( 'rank-math', 'rank-math-404-monitor' );
	
	remove_submenu_page( 'rank-math', 'rank-math-seo-analysis' );
	
	remove_submenu_page( 'rank-math', 'rank-math-status' );
	
	remove_submenu_page( 'rank-math', 'rank-math-options-instant-indexing' );
	
	remove_submenu_page( 'rank-math', 'rank-math-role-manager' );
	
	remove_submenu_page( 'rank-math', 'rank-math-redirections' );
	
	remove_submenu_page( 'rank-math', 'nagatheme-knowledge-base' );
	
}