<?php
namespace Aepro\Modules\DynamicCalendar\Skins;

use Aepro\Aepro;
use Aepro\Frontend;
use Aepro\Modules\DynamicCalendar\Classes\Calendar;
use Elementor\Core\Files\CSS\Post as Post_CSS;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Skin_1 extends Skin_Base {
	//phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore
	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/ae-dynamic-calendar/section_calendar_styles/after_section_start', [ $this, 'calendar_style_controls' ] );
		add_action( 'elementor/element/ae-dynamic-calendar/section_layout/after_section_start', [ $this, 'calendar_layout_controls' ] );
	}

	public function get_id() {
		return 'skin_1';
	}

	public function get_title() {
		return __( 'Skin 1', 'ae-pro' );
	}

	public function render() {

		$settings = $this->parent->get_settings_for_display();
		$this->generate_output( $settings, true );
	}

	public function generate_output( $settings, $with_wrapper ) {

		$post_arr     = $this->get_posts_by_date_arr( $settings );
		$post_by_date = [];
		$posts        = [];

		if ( $settings['calendar_source'] === 'custom_month' ) {
			$month = $settings['calendar_month'];
			$year  = $settings['calendar_year'];
		} else {
			$month = date( 'n' ); //0-12
			$year  = date( 'Y' ); //four digit
		}

		$date  = apply_filters(
			'aepro/dynamic_calendar/date',
			[
				'month' => $month,
				'year'  => $year,
			]
		);
		$month = $date['month'];
		$year  = $date['year'];

		if ( isset( $_POST['month'] ) ) {
			$month = $_POST['month'];
		}

		if ( isset( $_POST['year'] ) ) {
			$year = $_POST['year'];
		}

		//Layout
		$enable_overlay = $settings['enable_overlay'];

		// Outer Wrapper Attributes
		$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-outer-wrapper' );
		$this->parent->add_render_attribute( 'outer-wrapper', 'data-pid', get_the_ID() );
		$this->parent->add_render_attribute( 'outer-wrapper', 'data-wid', $this->parent->get_id() );
		$this->parent->add_render_attribute( 'dc-wrapper', 'class', 'ae-dc-wrapper' );
		$this->parent->add_render_attribute( 'dc-listing', 'class', 'ae-dc-listing' );
		if ( $settings['listing_position'] == 'overlap' ) {
			$this->parent->add_render_attribute( 'dc-listing', 'class', 'hidden' );
		}
		$this->parent->add_render_attribute( 'dc-listing-wrapper', 'class', 'ae-dc-listing-wrapper ae-height-100' );
		if ( $settings['listing_layout'] == 'carousel' ) {
			$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-swiper-outer-wrapper' );
			$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-carousel-yes' );
			if ( $settings['arrows_layout'] === 'inside' ) {
				$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-hpos-' . $settings['arrow_horizontal_position'] );
				$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-vpos-' . $settings['arrow_vertical_position'] );
			}
			$this->parent->add_render_attribute( 'outer-wrapper', 'data-swiper-settings', wp_json_encode( $this->parent->get_swiper_data( $settings ) ) );
			$this->parent->add_render_attribute( 'dc-listing-wrapper', 'style', 'display:none' );
		}
		$this->parent->get_widget_title_html();

		if ( $with_wrapper ) {
			?>
		<div <?php echo $this->parent->get_render_attribute_string( 'outer-wrapper' ); ?>>
			<?php
		}
			/* Ajax Overlay */
		if ( $enable_overlay == 'yes' ) {
			?>
				<div class="ae-post-overlay">
					<div class="ae-post-overlay-wrapper">
						<div class="ae-post-overlay-icon">
							<?php Icons_Manager::render_icon( $settings['overlay_icon'], [ 'aria-hidden' => 'true' ] ); ?>
						</div>
						<div class="ae-post-overlay-text">
							<?php echo $settings['overlay_text']; ?>
						</div>
					</div>
				</div>
				<?php
		}
		?>
			<div <?php echo $this->parent->get_render_attribute_string( 'dc-wrapper' ); ?>>
			<?php
			if ( isset( $post_arr ) && $post_arr ) {
				$post_by_date = $post_arr['post_by_date'];
				$posts        = $post_arr['posts'];
			}
				$calendar = new Calendar( $month, $year, $settings );
				echo $calendar->show( $post_by_date );
			if ( isset( $posts ) && $posts ) {
				?>
					<div <?php echo $this->parent->get_render_attribute_string( 'dc-listing' ); ?>>
						<div <?php echo $this->parent->get_render_attribute_string( 'dc-listing-wrapper' ); ?>>
						<?php
						foreach ( $posts as $key => $post ) {
							// Add Dynamic Classes Hook
							$custom_classes = apply_filters( 'aepro/dynamic-calendar/post-class', [], get_the_ID() );

							$item_classes = array_merge( [ 'dc-listing-item', 'ae-dc-' . $post['post_date'] ], $custom_classes );

							if ( $settings['listing_layout'] === 'carousel' ) {
								$item_classes[] = 'ae-swiper-slide swiper-slide';
							}

							// Post Item Attributes
							$this->parent->set_render_attribute( 'dc-listing-item', 'class', $item_classes );

							// Item Inner Attribute
							$item_inner_classes = [ 'dc-listing-item-inner' ];
							$this->parent->set_render_attribute( 'dc-listing-item-inner', 'class', $item_inner_classes );
							?>
								<div <?php echo $this->parent->get_render_attribute_string( 'dc-listing-item' ); ?>>
									<div <?php echo $this->parent->get_render_attribute_string( 'dc-listing-item-inner' ); ?>>
									<?php echo $post['template']; ?>
									</div>
								</div>
								<?php
						}
						?>
						</div>
						<?php
						if ( $settings['listing_layout'] == 'carousel' ) {
							//Swiper List Wrapper Attributes
							$this->parent->add_render_attribute( 'dc-swiper-wrapper', 'class', 'ae-swiper-wrapper ae-height=100 swiper-wrapper' );
							$this->parent->add_render_attribute( 'dc-listing-container', 'class', 'dc-listing-container ae-swiper-container swiper-container' );
							?>
						<div <?php echo $this->parent->get_render_attribute_string( 'dc-listing-container' ); ?>>
							<div <?php echo $this->parent->get_render_attribute_string( 'dc-swiper-wrapper' ); ?>>
							</div>
							<?php
							$this->get_swiper_pagination( $settings );
							/** Arrows Inside **/
							if ( $settings['navigation_button'] === 'yes' && $settings['arrows_layout'] === 'inside' ) {
								$this->get_swiper_arrows( $settings );
							}

							$this->get_swiper_scrolbar( $settings );
							?>
						</div>
							<?php
							/** Arrows Inside **/
							if ( $settings['navigation_button'] === 'yes' && $settings['arrows_layout'] === 'outside' ) {
								$this->get_swiper_arrows( $settings );
							}
						}
						if ( $settings['listing_position'] == 'overlap' ) {
							?>
						<div class="ae-listing-close"><span>x</span></div>
						<?php } ?>
						<?php if ( Plugin::instance()->editor->is_edit_mode() ) { ?>
						<div class="listing-preview">Preview</div>
						<?php } ?>
					</div>
				<?php
			} else {
				if ( $this->ae_no_post_message( $settings ) ) {
					$this->parent->add_render_attribute( 'dc-listing', 'class', 'no-posts' )
					?>
					<div <?php echo $this->parent->get_render_attribute_string( 'dc-listing' ); ?>><?php echo $this->ae_no_post_message( $settings ); ?></div>
					<?php
				}
			}
			?>
			</div>
		<?php
		if ( $with_wrapper ) {
			?>
		</div>
			<?php
		}
	}

	public function calendar_layout_controls( Widget_Base $widget ) {
		$this->parent = $widget;

		$this->add_control(
			'navigation_bar_heading',
			[
				'label'     => __( 'Navigation Bar', 'ae-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'after',
			]
		);

		$this->add_control(
			'navigation_order',
			[
				'label'        => __( 'Order', 'ae-pro' ),
				'type'         => Controls_Manager::SELECT,
				'options'      => [
					'prev_title_next' => __( 'Prev, Title, Next', 'ae-pro' ),
					'title_prev_next' => __( 'Title, Prev - Next', 'ae-pro' ),
					'prev_next_title' => __( 'Prev - Next, Title', 'ae-pro' ),
				],
				'default'      => 'prev_title_next',
				'prefix_class' => 'ae-dc-nav-',
				'render_type'  => 'template',
			]
		);

		$this->add_control(
			'navigation_justify',
			[
				'label'       => esc_html_x( 'Justify', 'ae-pro' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => true,
				'default'     => '',
				'options'     => [
					'flex-start' => [
						'title' => esc_html_x( 'Flex Start', 'ae-pro' ),
						'icon'  => 'eicon-flex eicon-justify-start-h',
					],
					'center' => [
						'title' => esc_html_x( 'Center', 'ae-pro' ),
						'icon'  => 'eicon-flex eicon-justify-center-h',
					],
					'flex-end' => [
						'title' => esc_html_x( 'Flex End', 'ae-pro' ),
						'icon'  => 'eicon-flex eicon-justify-end-h',
					],
					'space-between' => [
						'title' => esc_html_x( 'Space Between', 'ae-pro' ),
						'icon'  => 'eicon-flex eicon-justify-space-between-h',
					],
					'space-around' => [
						'title' => esc_html_x( 'Space Around', 'ae-pro' ),
						'icon'  => 'eicon-flex eicon-justify-space-around-h',
					],
					'space-evenly' => [
						'title' => esc_html_x( 'Space Evenly', 'ae-pro' ),
						'icon'  => 'eicon-flex eicon-justify-space-evenly-h',
					],
				],
				'selectors'   => [
					'{{WRAPPER}} div#ae-dynamic-calendar .ae-dc-header' => 'justify-content: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'navigation_item_indent',
			[
				'label'     => esc_html__( 'Item Spacing', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'max' => 200,
					],
				],
				'default'   => [
					'unit' => 'px',
					'size' => '10',
				],
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'navigation_prev_icon',
			[
				'label'            => __( 'Prev Icon', 'ae-pro' ),
				'type'             => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'skin'             => 'inline',
				'label_block'      => false,
				'default'          => [
					'value'   => 'fa fa-angle-left',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
			'navigation_next_icon',
			[
				'label'            => __( 'Next Icon', 'ae-pro' ),
				'type'             => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'skin'             => 'inline',
				'label_block'      => false,
				'default'          => [
					'value'   => 'fa fa-angle-right',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
			'navigation_icon_position',
			[
				'label'   => esc_html__( 'Icon Position', 'ae-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'left'  => esc_html__( 'Before', 'ae-pro' ),
					'right' => esc_html__( 'After', 'ae-pro' ),
				],
			]
		);

		$this->add_control(
			'navigation_icon_indent',
			[
				'label'     => esc_html__( 'Icon Spacing', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'max' => 50,
					],
				],
				'default'   => [
					'unit' => 'px',
					'size' => '5',
				],
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-navigation .prev-icon.icon-after' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-navigation .prev-icon.icon-before' => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-navigation .next-icon.icon-after' => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-navigation .next-icon.icon-before' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);
	}

	public function calendar_style_controls( Widget_Base $widget ) {
		$this->parent = $widget;

		//Navigation Bar
		$this->add_control(
			'navigation_bar_styles',
			[
				'label'     => __( 'Navigation Bar', 'ae-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'after',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'navigation_typography',
				'label'    => __( 'Typography', 'ae-pro' ),
				/* 'fields_options' => [
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '15',
						],
					],
					'line_height' => [
						'default' => [
							'unit' => 'px',
							'size' => '15',
						],
					],
				], */
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header',
			]
		);

		$this->add_control(
			'navigation_text_color',
			[
				'label'     => __( 'Text Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header, {{WRAPPER}} #ae-dynamic-calendar .ae-dc-header a' => 'color:{{VAlUE}};',
				],
				'default'   => '#FFFFFF',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'           => 'navigation_bg_color',
				'label'          => __( 'Background', 'ae-pro' ),
				'types'          => [ 'none', 'classic', 'gradient' ],
				'selector'       => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header',
				'exclude'        => [ 'image' ],
				'fields_options' => [
					'background' => [
						'default' => 'classic',
					],
				],
			]
		);

		$this->add_control(
			'navigation_icon_color',
			[
				'label'     => __( 'Icon Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header i' => 'color:{{VAlUE}};',
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header svg' => 'fill:{{VAlUE}};',
				],
				'default'   => '#FFFFFF',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'navigation_border',
				'label'    => __( 'Border', 'ae-pro' ),
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header',
			]
		);

		$this->add_control(
			'navigation_border_radius',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'navigation_box_shadow',
				'label'    => __( 'Box Shadow', 'ae-pro' ),
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header',
			]
		);

		$this->add_control(
			'navigation_padding',
			[
				'label'      => __( 'Padding', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'navigation_margin',
			[
				'label'       => __( 'Margin', 'ae-pro' ),
				'type'        => Controls_Manager::DIMENSIONS,
				'placeholder' => [
					'top'    => '',
					'right'  => 'auto',
					'bottom' => '',
					'left'   => 'auto',
				],
				'size_units'  => [ 'px', 'em', '%' ],
				'selectors'   => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-header' => 'margin-top: {{TOP}}{{UNIT}}; margin-bottom: {{BOTTOM}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'navigation_divider',
			[
				'type'  => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		//Days Label

		$this->add_control(
			'days_label_styles',
			[
				'label'     => __( 'Day Label', 'ae-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'after',
			]
		);

		$this->add_responsive_control(
			'days_label_align',
			[
				'label'     => __( 'Alignment', 'ae-pro' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left' => [
						'title' => __( 'Left', 'ae-pro' ),
						'icon'  => 'eicon-h-align-left',
					],
					'right' => [
						'title' => __( 'Right', 'ae-pro' ),
						'icon'  => 'eicon-h-align-right',
					],
					'center' => [
						'title' => __( 'Center', 'ae-pro' ),
						'icon'  => 'eicon-h-align-center',
					],
				],
				'selectors' => [
					'{{WRAPPER}} div#ae-dynamic-calendar .ae-dc-day-cell' => 'text-align: {{VALUE}}',
				],
				'default'   => 'center',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'days_label_typography',
				'label'    => __( 'Typography', 'ae-pro' ),
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell',
			]
		);

		$this->start_controls_tabs( 'tabs_days_label_styles' );

		$this->start_controls_tab(
			'tab_days_label_normal',
			[
				'label' => __( 'Normal', 'ae-pro' ),
			]
		);

		$this->add_control(
			'days_label_color',
			[
				'label'     => __( 'Text Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell' => 'color:{{VAlUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'days_label_bg_color',
				'label'    => __( 'Background', 'ae-pro' ),
				'types'    => [ 'none', 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell',
				'exclude'  => [ 'image' ],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'days_label_border',
				'label'    => __( 'Border', 'ae-pro' ),
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_days_label_hover',
			[
				'label' => __( 'Hover', 'ae-pro' ),
			]
		);

		$this->add_control(
			'days_label_hover_color',
			[
				'label'     => __( 'Text Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell:hover' => 'color:{{VAlUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'days_label_bg_hover_color',
				'label'    => __( 'Background', 'ae-pro' ),
				'types'    => [ 'none', 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell:hover',
				'exclude'  => [ 'image' ],
			]
		);

		$this->add_control(
			'days_label_border_hover_color',
			[
				'label'     => __( 'Border Hover Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'days_label_border_radius',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'days_label_box_shadow',
				'label'    => __( 'Box Shadow', 'ae-pro' ),
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell',
			]
		);

		$this->add_control(
			'days_label_padding',
			[
				'label'      => __( 'Padding', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'days_label_margin',
			[
				'label'      => __( 'Margin', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} 0;',
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-day-cell:last-child' => 'margin-right:0',
				],
			]
		);

		$this->add_control(
			'days_label_divider',
			[
				'type'  => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		//Date Cell

		$this->add_control(
			'date_cell_styles',
			[
				'label'     => __( 'Date Cell', 'ae-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'after',
			]
		);

		$this->add_responsive_control(
			'date_cell_align',
			[
				'label'     => __( 'Alignment', 'ae-pro' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left' => [
						'title' => __( 'Left', 'ae-pro' ),
						'icon'  => 'eicon-h-align-left',
					],
					'right' => [
						'title' => __( 'Right', 'ae-pro' ),
						'icon'  => 'eicon-h-align-right',
					],
					'center' => [
						'title' => __( 'Center', 'ae-pro' ),
						'icon'  => 'eicon-h-align-center',
					],
				],
				'selectors' => [
					'{{WRAPPER}} div#ae-dynamic-calendar .ae-dc-date-cell' => 'text-align: {{VALUE}}',
				],
				'default'   => 'center',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'date_cell_typography',
				'label'    => __( 'Typography', 'ae-pro' ),
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell',
			]
		);

		$this->start_controls_tabs( 'tabs_date_cell_styles' );

		$this->start_controls_tab(
			'tab_date_cell_normal',
			[
				'label' => __( 'Normal', 'ae-pro' ),
			]
		);

		$this->add_control(
			'date_cell_color',
			[
				'label'     => __( 'Text Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell' => 'color:{{VAlUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'date_cell_bg_color',
				'label'    => __( 'Background', 'ae-pro' ),
				'types'    => [ 'none', 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell',
				'exclude'  => [ 'image' ],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'date_cell_border',
				'label'    => __( 'Border', 'ae-pro' ),
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_date_cell_hover',
			[
				'label' => __( 'Hover', 'ae-pro' ),
			]
		);

		$this->add_control(
			'date_cell_hover_color',
			[
				'label'     => __( 'Text Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell:hover' => 'color:{{VAlUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'date_cell_bg_hover_color',
				'label'    => __( 'Background', 'ae-pro' ),
				'types'    => [ 'none', 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell:hover',
				'exclude'  => [ 'image' ],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'date_cell_border_hover',
				'label'    => __( 'Border', 'ae-pro' ),
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell:hover',
			]
		);

		/* $this->add_control(
			'date_cell_border_hover_color',
			[
				'label'     => __( 'Border Hover Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell:hover' => 'border-color: {{VALUE}}',
				],
			]
		); */

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_date_cell_active',
			[
				'label' => __( 'Active', 'ae-pro' ),
			]
		);

		$this->add_control(
			'date_cell_active_color',
			[
				'label'     => __( 'Text Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell.active' => 'color:{{VAlUE}};',
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell.active a' => 'color:{{VAlUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'date_cell_bg_active_color',
				'label'    => __( 'Background', 'ae-pro' ),
				'types'    => [ 'none', 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell.active',
				'exclude'  => [ 'image' ],
			]
		);

		$this->add_control(
			'date_cell_border_active_color',
			[
				'label'     => __( 'Border Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell.active' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'date_cell_border_radius',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'date_cell_box_shadow',
				'label'    => __( 'Box Shadow', 'ae-pro' ),
				'selector' => '{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell',
			]
		);

		$this->add_control(
			'date_cell_padding',
			[
				'label'      => __( 'Padding', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'date_cell_margin',
			[
				'label'      => __( 'Margin', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} 0;',
					'{{WRAPPER}} #ae-dynamic-calendar .ae-dc-date-cell.end' => 'margin-right:0',
				],
			]
		);
	}
	public function get_swiper_pagination( $settings ) {
		if ( $settings['ptype'] !== '' ) {
			?>
			<div class = "ae-swiper-pagination swiper-pagination"></div>
			<?php
		}
	}

	public function get_swiper_scrolbar( $settings ) {
		if ( $settings['scrollbar'] === 'yes' ) {
			?>
			<div class = "ae-swiper-scrollbar swiper-scrollbar"></div>
			<?php
		}
	}

	public function get_swiper_arrows( $settings ) {

		if ( $settings['arrow_horizontal_position'] !== 'center' && $settings['arrows_layout'] === 'inside' ) {
			?>
			<div class="ae-swiper-button-wrapper">
			<?php
		}
		?>
		<div class = "ae-swiper-button-prev swiper-button-prev">
			<?php
			if ( is_rtl() ) {
				Icons_Manager::render_icon( $settings['arrow_icon_right'], [ 'aria-hidden' => 'true' ] );
			} else {
				Icons_Manager::render_icon( $settings['arrow_icon_left'], [ 'aria-hidden' => 'true' ] );
			}
			?>
		</div>
		<div class = "ae-swiper-button-next swiper-button-next">
			<?php
			if ( is_rtl() ) {
				Icons_Manager::render_icon( $settings['arrow_icon_left'], [ 'aria-hidden' => 'true' ] );
			} else {
				Icons_Manager::render_icon( $settings['arrow_icon_right'], [ 'aria-hidden' => 'true' ] );
			}
			?>
		</div>
		<?php
		if ( $settings['arrow_horizontal_position'] !== 'center' && $settings['arrows_layout'] === 'inside' ) {
			;
			?>
			</div>
			<?php
		}
	}
}
