<?php defined('ABSPATH') || exit ("no access");  ?>
<div id="main-guard-inner">
    <div class="license-input">
        <h1> <?php printf(esc_html__('%s Activation', 'guard-gn-d92e00e02e1eb8faf377010e'), esc_html__($this->f4782d39a9a4c337a0c2a27d44a346f, 'guard-gn-d92e00e02e1eb8faf377010e')); ?></h1>
        <?php if ($this->d4e9d3fe14eb1fa727fa2b2c1fd861e): ?>
            <h3><?php esc_html_e('Your activation key:', 'guard-gn-d92e00e02e1eb8faf377010e') ?></h3>
            <code id="code-style"><?php echo $this->a4123e7d74bb486f7982b072025b() ?></code>
            <div class="text-left">
                    <span id="recheck-license" onclick="recheck_licence(this)"><?php esc_html_e('Recheck license', 'guard-gn-d92e00e02e1eb8faf377010e') ?></span>
                    <span id="remove-license" onclick="remove_licence(this)"><?php esc_html_e('Remove / Change key', 'guard-gn-d92e00e02e1eb8faf377010e') ?></span>
            </div>
            <div id="license-message" style="display: flex; <?php echo ($this->fc5fbf9d646273cd2b7ffe568a9e97e===true)? 'background:red;':''?>">
                <div class="result" style=""><?php echo $this->dfbc3c3d7c099efb988010c81546ad('last_message'); ?></div>
            </div>
            <!-- /#license-message -->
        <?php else: ?>
            <h3><?php esc_html_e('Enter your activation key:', 'guard-gn-d92e00e02e1eb8faf377010e') ?></h3>
            <input id="license-input" type="text" value="">
            <div class="text-left">
                    <span id="install-license" onclick="install_licence(this)"><?php esc_html_e('Activate',
                            'guard-gn-d92e00e02e1eb8faf377010e') ?></span>
            </div>
            <div id="license-message">
            </div>
        <?php endif; ?>

        <!-- /#license-message -->
        <?php
        $crons=get_option('cron');
        $last_cron_run=false;
        foreach ($crons as $time => $cron){
            if (!is_array($cron)){
                continue;
            }
            if (isset($cron['zhaket_guard_daily_validator'])) {
                $last_cron_run = $time;
            }
        }
        if (empty($last_cron_run)){
            ?>
            <div id="license-message" style="display: flex; background:red;">
                <div class="result" ><?php esc_html_e('No cron jobs found. Your license can not be activated.', 'guard-gn-d92e00e02e1eb8faf377010e'); ?></div>
            </div>
            <?php
        }elseif($last_cron_run < time()-90000 || $last_cron_run > time()+90000){
            ?>
            <div id="license-message" style="display: flex; background:red;">
                <div class="result" ><?php printf(__('Number of failed Activation checks is reached (%s). your plugin or theme will be disabled soon. Please check cron job settings on your WordPress or host. <a href="%s">cron manual</a>', 'guard-gn-d92e00e02e1eb8faf377010e'),human_time_diff( $last_cron_run),'https://codekraken.ir/cron-manual'); ?></div>
            </div>
            <?php
        }
        ?>
        <div id="license-help">
            <strong><?php esc_html_e('Manual:', 'guard-gn-d92e00e02e1eb8faf377010e') ?></strong>
            <ul>
                <?php if ($this->d4e9d3fe14eb1fa727fa2b2c1fd861e): ?>
                    <li>
                        <?php esc_html_e('Your key is used on this website, and it is not possible to use on another website.',
                            'guard-gn-d92e00e02e1eb8faf377010e') ?>
                    </li>
                    <li>
                        <?php esc_html_e('If you want to transfer a license to another domain, click on the "Remove / Change key", after that login to your account of zhaket.com and go to the download section and click on change domain button. Enter your new domain name and use the license key on your desired domain.',
                            'guard-gn-d92e00e02e1eb8faf377010e') ?>
                    </li>
                <?php else: ?>
                    <li>
                        <?php esc_html_e('To use the product, you should enter the license key, to find your license key, login to your account of zhaket.com and go to downloads section, after than select product and copy your license key or click on create license button and copy your license key.',
                            'guard-gn-d92e00e02e1eb8faf377010e') ?>
                    </li>
                    <li>
                        <?php esc_html_e('Each license can be activated only for one website', 'guard-gn-d92e00e02e1eb8faf377010e') ?>
                    </li>
                    <li>
                        <?php esc_html_e('If your license is activated on another domain, first click on the "Remove / Change key" on the old website, then login to your account of zhaket.com and go to the download section and click on the change domain button, enter your website domain name and use the license key to activate.',
                            'guard-gn-d92e00e02e1eb8faf377010e') ?>
                    </li>
                <?php endif; ?>
            </ul>
            <?php
            if ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ) {
                echo '<hr>';
                echo sprintf( esc_html__( 'The %s constant is set to true. WP-Cron spawning is disabled.', 'guard-gn-d92e00e02e1eb8faf377010e' ), 'DISABLE_WP_CRON' );
            }
            if ( defined( 'ALTERNATE_WP_CRON' ) && ALTERNATE_WP_CRON ) {
                echo '<hr>';
                echo sprintf( esc_html__( 'The %s constant is set to true.', 'guard-gn-d92e00e02e1eb8faf377010e' ), 'ALTERNATE_WP_CRON'
                );
            }

            ?>
            <hr>
            <span style="display: block;direction: ltr;text-align:left;font-size: 10px">version:1.1.0</span>
        </div>


    </div>
    <!-- /.license-input -->
    <div class="background-status">
        <?php if ($this->d4e9d3fe14eb1fa727fa2b2c1fd861e): ?>
            <img src="<?php echo $this->dcd17aab48bb4dc89d2f2c7e00df90f ?>assets/unlocked.png" alt="">
        <?php else: ?>
            <img src="<?php echo $this->dcd17aab48bb4dc89d2f2c7e00df90f ?>assets/locked.png" alt="">
        <?php endif; ?>
    </div>
    <!-- /.background-status -->
</div>
<!-- /#main-guard-inner -->