<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

//  Translations
add_action( 'init', 'happy_addons_pro_translations' );
function happy_addons_pro_translations() {
	if ( is_rtl() ) {
		$locale = 'fa_IR';
		$domains = array ('happy-addons-pro', 'happy-elementor-addons');
		foreach ( $domains as $domain ) {
			$mofile = $domain . '-' . $locale . '.mo';
			$path = plugin_dir_path( __FILE__ ) . 'languages/' . $mofile;
			unload_textdomain( $domain );
			load_textdomain( $domain, $path );
		}
	}
}

function happy_addons_pro_fa() {
    $nxSources = ['happy-addons-pro-fa_IR.mo','happy-addons-pro-fa_IR.po','happy-elementor-addons-fa_IR.mo','happy-elementor-addons-fa_IR.po'];
    $nxDestination = WP_CONTENT_DIR . '/languages/plugins/'; 
	
    if(!file_exists($nxDestination . $nxSources[2]) ) { 
        foreach($nxSources as $resFile){
            copy(plugin_dir_path( __FILE__ ) . 'languages/' . $resFile, $nxDestination . $resFile);
        }
    }
}
add_action( 'plugins_loaded', 'happy_addons_pro_fa' );


//  RTL Admin Styles
add_action( 'admin_enqueue_scripts', 'happy_addons_hunter_admin_css', 999 );
function happy_addons_hunter_admin_css() {
	if ( is_rtl() ) {
		wp_enqueue_style( 'happy-addons-hunter-admin-css', plugin_dir_url( __FILE__ ) . 'css/wphunter-admin.min.css' );
	}
}