/**
 * Smooth Scroll JS
 */

function init() {
 if (!SmoothScroller_Settings) return;
 const smooth = SmoothScroller_Settings.smoothness !== "" ? SmoothScroller_Settings.smoothness : 12,
   trigger = SmoothScroller_Settings.selector;

   var newSmooth = smooth / 8; // previous value converted to new value for GSAP smooth scrolling

    // create the smooth scroller FIRST!
    ScrollSmoother.create({
        smooth: newSmooth,
        effects: true,
    });

    // then create the GSAP scroll trigger pin element    
    if (trigger !== '') {
        gsap.to(trigger, {
            scrollTrigger: {
                trigger: trigger,
                endTrigger: 'body',
                pin: true,
                start: 'top top',
                end: 'bottom bottom',
                pinSpacing: false,                
            },
            zIndex: 999,
            position: 'relative',
        });
    }
}

window.addEventListener('DOMContentLoaded', () => {
    init();
})